/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence.builder;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;

public interface ISequenceBuilder<T extends ISequenceBuilder<T, S>, S extends CharSequence>
extends Appendable {
    @Nullable
    public S getSingleBasedSequence();

    @NotNull
    public T getBuilder();

    @NotNull
    default public T addAll(Iterable<? extends CharSequence> sequences) {
        return this.append(sequences);
    }

    public char charAt(int var1);

    @NotNull
    default public T append(Iterable<? extends CharSequence> sequences) {
        for (CharSequence charSequence : sequences) {
            this.append(charSequence, 0, charSequence.length());
        }
        return (T)this;
    }

    @NotNull
    default public T add(@Nullable CharSequence chars) {
        return (T)this.append(chars);
    }

    @NotNull
    default public T append(@Nullable CharSequence chars) {
        if (chars != null) {
            return (T)this.append(chars, 0, chars.length());
        }
        return (T)this;
    }

    @NotNull
    default public T append(@Nullable CharSequence chars, int startIndex) {
        if (chars != null) {
            return (T)this.append(chars, startIndex, chars.length());
        }
        return (T)this;
    }

    @NotNull
    public T append(@Nullable CharSequence var1, int var2, int var3);

    @NotNull
    public T append(char var1);

    @NotNull
    public T append(char var1, int var2);

    @NotNull
    public S toSequence();

    public int length();

    default public boolean isEmpty() {
        return this.length() <= 0;
    }

    default public boolean isNotEmpty() {
        return this.length() > 0;
    }
}

